<?php
/*
	Stempora web framework
	copyright (c) 2002-2016 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CLanguages extends CPlugin{
	
	var $tplvars; 
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $languages = array();
	

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){

		if ($_GET["mod"] == "language") {
			switch ($_GET["sub"]) {
				case "change":
					return $this->ChangeLanguage();
				break;
			}
		}


	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ReadVars() {

		global $_LANG , $_LANG_CODE;

		$vars = $this->db->QFetchRowArray("SELECT lang_var , lang_{$_LANG_CODE}_val AS val from {$this->tables['core:languages_vars']}");
	
		if (is_array($vars)) {
			foreach ($vars as $key => $val) {
				$_LANG[$val["lang_var"]] = $val["val"];
			}			
		}		
	}
		

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DetectLang($code = "") {

		$this->LoadLanguages();		

		//if no code then get the first language
		if (!$code) {
			reset($this->languages);
			$lang = $this->languages[key($this->languages)];
		} else {
	
			if (is_array($this->languages[$code])) {
				$lang = $this->languages[$code];
			} else {
				reset($this->languages);
				$lang = $this->languages[key($this->languages)];
			}
			
		}
						

		global $_LANG_CODE , $_LANG_ID , $_LANG_RAW , $_LANG;

		if ($lang["lang_locale_date"]) {
			setlocale(LC_ALL , $lang["lang_locale_date"] . ".utf8" );
		}

		$_GET["_LANG"] = $_LANG = $_LANG_CODE = $lang["lang_code"];
		$_LANG_ID = $lang["lang_id"];
		$_LANG_RAW = $lang;

		if (!$code) {
			global $_LANG;

			$_LANG = $lang["lang_code"];
		}


		
		
	}

	

	function DefaultLang() {

		$this->LoadLanguages();		


		$lang = $this->languages[$this->default_lang];


		global $_LANG_CODE , $_LANG_ID , $_LANG_RAW , $_LANG;


		$_LANG = $_LANG_CODE = $lang["lang_code"];
		$_LANG_ID = $lang["lang_id"];
		$_LANG_RAW = $lang;


		if ($lang["lang_locale_date"]) {
			setlocale(LC_TIME , $lang["lang_locale_date"] . ".utf8" );
		}

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetMenuButton($module) {
		

		if (!$this->cached_menu) {
			$this->cached_menu = array(
				"html"	=> $this->RenderMenu()
			);
		}

		if ($this->cached_menu["html"]) {
			return $this->cached_menu;
		}
		
		
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Menu($tpl) {
		$this->vars->data["set_language_menu_style"] = 0;
		return $this->RenderMenu($tpl);
	}
	
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access	
	*/
	function RenderMenu($template = null) {
		global $_LANG , $base , $site;

		if (!$this->vars->data["set_multilanguage"]) {
			return "";
		}

		$this->LoadLanguages();

		$this->__init();

		if ($template != null) {
			$tpl = $template;
		} else {
			$tpl = $this->private->templates["main"];
		}
		

		$langs = $this->languages;


		if (is_array($langs) && (count($langs) > 1)) {

			foreach ($langs as $key => $val) {
				$langs[$key]["selected"] = $val["lang_code"] == $_LANG ? $tpl->blockReplace("Selected" , array()) : "";
				$langs[$key]["icon"] = $val["lang_icon"] ? $tpl->blockReplace("ElementIcon" , $val) : "";

				if ($_LANG == $val["lang_code"]) {
					$selected = $val;
				}
				
			}

			if ($this->vars->data["set_language_menu_style"]) {
				return $base->html->Table(
					$tpl , 
					"Links" , 
					$langs
				);
			}

			foreach ($langs as $key => $val) {
				if ($val["selected"]) {
					unset($langs[$key]);
				}
				
			}


			if ($this->vars->data["set_language_menu_icon"]) {
				$mainicon = $this->vars->data["set_language_menu_icon"];
			} elseif ($selected["lang_icon"]) {
				$mainicon = $selected["lang_icon"];
			}

			if ($mainicon) {
				$mainicon = $tpl->blockReplace("Icon" , array("SET_LANGUAGE_MENU_ICON" => $mainicon));
			}
			
			return $tpl->blockReplace(
				"Main",
				array(
					"menu"	=> $base->html->Table(
						$tpl , 
						"" , 
						$langs,
						$this->plugins["backgrounds"]->GetBg($this->vars->data["set_language_bg"])
					),
					"current"	=> $tpl->blockREplace(
						"Current" , 
						$selected,
						array(
							"icon"	=> $mainicon
						)
					)
				)
			);

		}
		

	}
	

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"		=> "main.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function LoadVars() {
		global $_LANG , $_LANG_ID;


		$vars = $this->db->QFetchRowArray(
				"SELECT * FROM 
					{$this->tables['core:languages_vars']} as v,
					{$this->tables['core:languages_vars_lang']} as l
				WHERE
					v.var_id = l.var_id AND 
					l.lang_id = {$_LANG_ID}
					"
			);

		if (is_array($vars)) {
			foreach ($vars as $key => $val) {
		
				$data["LANG:" . strtoupper($val["var_name"])] = $val["var_value"];
			}
			
		}

		return $data;
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function LoadLanguages() {
		global $_CONF, $_SESS;

		if (!$this->languages) {

			//if logged in load pending languages
			if (is_array($_SESS["minibase"]["raw"])) {
				$langs = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_status >= 1 order by lang_order ASC ");
			} else {			
				$langs = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:languages']} WHERE lang_status = 1 order by lang_order ASC ");
			}
			if (is_array($langs)) {
				foreach ($langs as $key => $val) {

					if ($val["lang_default"]) {
						$val["abslink"] = $_CONF["url"]; //. "/";
					} else {
						$val["abslink"] = $_CONF["url"] . $val["lang_code"] . "/";
					}

					$val["link"] = $_CONF["url"] . "__locale__/lang/" . $val["lang_code"] . "/";
					
					$this->languages[$val["lang_code"]] = $val;



					/*
					if ($val["lang_default"]) {

						$this->default_lang = $val["lang_code"];
					}*/
					
				}				
			}			

			$this->default_lang = $this->private->vars->data["set_language"];

			$this->languages_count = count($this->languages);;

		}				
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ChangeLanguage() {
		global $_CONF;

		$this->LoadLanguages();		

		$code = $_GET["lang_code"];

		if (!is_array($this->languages[$code])) {
			$code = $this->default_lang;
		}

		if (is_array($lang = $this->languages[$code])) {

			setcookie ( 
				"lang" , 
				$code,
				time() + 3600 * 24 * 30, 
				"/"
			);

			if ($lang["lang_default"]) {
				urlredirect($_CONF["url"]);
			} else {
				urlredirect($_CONF["url"] . $lang["lang_code"] . "/");
			}
				
						
		}

		
	}
	
}

?>